#include "../header/aerotri_trabajos.h"
#include "../header/Atcrt/Atpaths.h"
#include <stdio.h>
#include <direct.h>

int compute_from_file(const char16_t *art_file){
	TrabajoAerotri *tr;
	int nret;
	char16_t mensaje[512];

#ifdef _DEBUG
	puts("Presione una tecla para continuar");
	getchar();
#endif
	tr=get_trabajo_aerotri();
	if(tr==NULL){ /*out of memory*/ }
	nret=lee_trabajoAT(art_file,tr);
	
	//File names within trabajo are most likely relative paths. Therefore we must
	//	either		Compose the (either absolute or relative) path from art_file with those file names
	//	or			Change the current path to that from art_file.
	//We take the second approach
	{char16_t path[MAX_PATH], *s1;
	const char16_t *s2, *sfinal;
	path_get_filename16(art_file,sfinal);
	for(s1=path, s2=art_file; s2!=sfinal; *s1++=*s2++);
	*s1=u'\0';
	_wchdir(path);
	}

	nret=calcula_trabajoAT(NULL,0,tr,true,mensaje,ATIDIOMA_Eng);
	if(nret==AT_ESC){
		return AT_ESC;
	}else if(nret!=0 && nret<1000){//Error in the data from trabajo (missing or wrong input data)
		//See possible values for nret at aerotri_trabajos.h
		printf("Error in the data from trabajo %i",nret);
	}else{
		char smensj[512];
		int i; for(i=0;i<512;i++) smensj[i]=(char)mensaje[i];
		puts(smensj);
	}

	libera_trabajoAT(tr);	//done with tr
	ATtrabajos_free(tr);
	return nret;
}

int wmain(int argc, wchar_t* argv[]){
	compute_from_file(u"C:\\ProgramData\\Aerotri\\Ejemplos_Aerotri\\edificio\\edificio_org.art");
	return 0;
}
